<?php $__env->startSection('content'); ?>
<main class="content">
    <div class="container-fluid p-0">

        <div class="row mb-2 mb-xl-3">
            <div class="col-auto d-none d-sm-block">
                <h3><strong>All</strong> Users</h3>
            </div>
            
            <div class="col-auto ms-auto text-end mt-n1">
                <a href="<?php echo e(route('create.user')); ?>" class="btn btn-primary">Create New User</a>
            </div> 
           
            
        </div>
        <div class="row">
            <div class="col-12">
                
                <div class="card">                    
                    <div class="card-body">
                        <table id="datatables-reponsive" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><img class="rounded-circle" src="<?php echo e((!empty($item->photo)) ? url($item->photo) : url('upload/no_image.jpg')); ?>" alt="" style="width: 70px; height:40px;"></td>
                                    <td><?php echo e($item->name??''); ?></td>
                                    <td><?php echo e($item->email??''); ?></td>
                                    <td>
                                        <?php if( $item->role == 'user'): ?>
                                        <span class="badge bg-warning">User</span>
                                        <?php else: ?>
                                        <span class="badge bg-success">Admin</span>
                                        <?php endif; ?>
                                    </td>
                                    <?php if($item->status == 'active'): ?>
                                        <td><a href="#" class="badge rounded-pill bg-success" onclick="changeUserStatus(<?php echo e($item->id); ?>)">Active</a></td>
                                        <?php else: ?>
                                        <td><a href="#" class="badge rounded-pill bg-danger" onclick="changeUserStatus(<?php echo e($item->id); ?>)">In Active</a></td>
                                    <?php endif; ?>
                                    <td>
                                        <a href="<?php echo e(route('edit.user',$item->id)); ?>" class="btn btn-pill btn-info" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit"> <i data-feather="edit"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</main>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Datatables Responsive
        $("#datatables-reponsive").DataTable({
            responsive: true,
            "drawCallback": function( settings ) {
                feather.replace();
            }
        });
    });

    function changeUserStatus(id) {
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/change_user_status',
            data: {'id': id},
            success: function(data){
                
                
                // Start Message 
            const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    icon: 'success', 
                    showConfirmButton: false,
                    timer: 5000 
            })
            if ($.isEmptyObject(data.error)) {
                    
                    Toast.fire({
                    type: 'success',
                    title: data.success, 
                    })
            }else{
                
            Toast.fire({
                    type: 'error',
                    title: data.error, 
                    })
                }
                location.reload()
                // End Message   
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kreditoh/public_html/agri_stock/resources/views/backend/user/all_user.blade.php ENDPATH**/ ?>