<?php
    $userInfo = Illuminate\Support\Facades\Auth::user();
?>
<nav id="sidebar" class="sidebar js-sidebar">
    <div class="sidebar-content js-simplebar">
        <a class="sidebar-brand" href="<?php echo e(route('dashboard')); ?>">
            <span class="sidebar-brand-text align-middle">
                Agri Stock
            </span>
        </a>

        <div class="sidebar-user">
            <div class="d-flex justify-content-center">
                <div class="flex-shrink-0">
                    <img src="<?php echo e((!empty($userInfo->photo)) ? url($userInfo->photo) : url('upload/no_image.jpg')); ?>" class="avatar img-fluid rounded me-1" alt="Jassa">
                </div>
                <div class="flex-grow-1 ps-2">
                    <a class="sidebar-user-title dropdown-toggle" href="#" data-bs-toggle="dropdown">
                        <?php echo e($userInfo->name??''); ?>

                    </a>
                    <div class="dropdown-menu dropdown-menu-start">
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="dropdown-item">
                                Log out
                            </button>
                        </form>
                    </div>

                    <div class="sidebar-user-subtitle"><?php echo e($userInfo->role??''); ?></div>
                </div>
            </div>
        </div>

        <ul class="sidebar-nav">
            <li class="sidebar-item active">
                <a class="sidebar-link" href="<?php echo e(route('dashboard')); ?>">
                    <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Dashboards</span>
                </a>
            </li>
            <li class="sidebar-item">
                <a href="#review" data-bs-toggle="collapse" class="sidebar-link collapsed">
                    <i class="align-middle" data-feather="trello"></i> <span class="align-middle">Customer Review</span>
                </a>
                <ul id="review" class="sidebar-dropdown list-unstyled collapse " data-bs-parent="#sidebar">
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('all.review')); ?>">All Review</a></li>
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('create.review')); ?>">Create Review</a></li>
                </ul>
            </li>
            <li class="sidebar-item">
                <a href="#auth" data-bs-toggle="collapse" class="sidebar-link collapsed">
                    <i class="align-middle" data-feather="users"></i> <span class="align-middle">Auth</span>
                </a>
                <ul id="auth" class="sidebar-dropdown list-unstyled collapse " data-bs-parent="#sidebar">
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('all.user')); ?>">All User</a></li>
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('create.user')); ?>">Create User</a></li>  
                </ul>
            </li>

            <li class="sidebar-item">
                <a href="#setting" data-bs-toggle="collapse" class="sidebar-link collapsed">
                    <i class="align-middle" data-feather="settings"></i> <span class="align-middle">Settings</span>
                </a>
                <ul id="setting" class="sidebar-dropdown list-unstyled collapse " data-bs-parent="#sidebar">
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('settings')); ?>">General Setting</a></li>
                    <li class="sidebar-item"><a class="sidebar-link" href="<?php echo e(route('edit.input.field')); ?>">Edit Input Field</a></li>  
                </ul>
            </li>
        </ul>
    </div>
</nav><?php /**PATH /home/kreditoh/public_html/agri_stock/resources/views/backend/home/sidebar.blade.php ENDPATH**/ ?>