<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\IndexController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Backend\ReportController;
use App\Http\Controllers\Backend\SettingController;
use App\Http\Controllers\Backend\LoginUserController;
use App\Http\Controllers\Backend\CustomerReviewController;
use App\Http\Controllers\Backend\InputFieldPlaceHolderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/clear-cache', function () {
    Artisan::call('optimize:clear');
    return 'Cache Cleared';
});

Route::get('/',[HomeController::class,'index']);
Route::post('/sent/mail',[HomeController::class,'sentEmail'])->name('sent.mail');


// Auth Route
Route::get('/login',[LoginUserController::class,'index'])->name('login');
Route::post('/login',[LoginUserController::class,'login'])->name('auth.login');
Route::post('/logout',[LoginUserController::class,'logout'])->name('logout');

// Dashboard Route
Route::middleware(['auth','roles:admin'])->group(function () {
    Route::get('/dashboard',[IndexController::class,'index'])->name('dashboard');
    Route::get('/view/email/{id}',[IndexController::class,'viewMail'])->name('view.mail');
});

// User Route
Route::middleware(['auth','roles:admin'])->group(function () {

    Route::get('/all/user',[UserController::class,'index'])->name('all.user');
    Route::get('/create/user',[UserController::class,'create'])->name('create.user');
    Route::post('/store/user',[UserController::class,'store'])->name('store.user');
    Route::get('/edit/user/{id}',[UserController::class,'edit'])->name('edit.user');
    Route::post('/update/user',[UserController::class,'update'])->name('update.user');
    Route::get('change_user_status',[UserController::class,'changeUserStatus']);
});

// Review Route
Route::middleware(['auth','roles:admin'])->group(function () {
    Route::get('/all/review',[CustomerReviewController::class,'index'])->name('all.review');
    Route::get('/create/review',[CustomerReviewController::class,'create'])->name('create.review');
    Route::post('/store/review',[CustomerReviewController::class,'store'])->name('store.review');
    Route::get('/edit/review/{id}',[CustomerReviewController::class,'edit'])->name('edit.review');
    Route::post('/update/review',[CustomerReviewController::class,'update'])->name('update.review');
    Route::get('/delete/review/{id}',[CustomerReviewController::class,'delete'])->name('delete.review');
    Route::get('change_review_status',[CustomerReviewController::class,'changeReviewStatus']);
});

// Setting Route
Route::middleware(['auth','roles:admin'])->group(function () {
    Route::get('/settings',[SettingController::class,'index'])->name('settings');
    Route::post('/settings/store',[SettingController::class,'store'])->name('settings.store');
    Route::get('/edit/input/field',[SettingController::class,'editInputField'])->name('edit.input.field');
    Route::post('/update/input/field',[SettingController::class,'updateInputField'])->name('update.input.field');
});




