@extends('backend.layout')
@section('content')
<main class="content">
    <div class="container-fluid p-0">

        <div class="row mb-2 mb-xl-3">
            <div class="col-auto d-none d-sm-block">
                <h3><strong>Update</strong> Setting</h3>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-xl-7">
                <div class="card">
                    
                    <div class="card-body">
                        <form action="{{route('settings.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="setting_id" value="{{$settings->id}}">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="logoText">Logo Text</label>
                                    <input name="logo_text" type="text" class="form-control" id="logoText" placeholder="Enter Logo Text" value="{{ $settings->logo_text??''}}">
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="copyightText">Copyright Text</label>
                                    <input name="copyright_text" type="text" class="form-control" id="copyightText" placeholder="Enter Copyright Text" value="{{ $settings->copyright_text??''}}" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="messageEmail">Receiver Email</label>
                                    <input name="message_email" type="email" class="form-control" id="messageEmail" placeholder="Message Email" value="{{ $settings->message_email??''}}" required>
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="contactEmail">Contact Email</label>
                                    <input name="contact_email" type="email" class="form-control" id="contactEmail" placeholder="Contact Email" value="{{ $settings->contact_email??''}}">
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="metaText">Meta Keyword</label>
                                    <input name="meta_keyword" type="text" class="form-control" id="metaText" placeholder="Meta Text" value="{{ $settings->meta_keyword??''}}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="bodyTitle">Body Title</label>
                                    <input name="body_title" type="text" class="form-control" id="bodyTitle" placeholder="Enter Body Title" value="{{ $settings->body_title??''}}" required>
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="revieBoxTitle">Review Box Title</label>
                                    <input name="review_box_title" type="text" class="form-control" id="revieBoxTitle" placeholder="Enter Review Box Title" value="{{ $settings->review_box_title??''}}" required>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Body Description</label>
                                <textarea name="body_description" class="form-control" placeholder="Body Description" rows="2" required>{{ $settings->body_description??''}}</textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Fav Icon</label>
                                <input name="fav_icon" type="file" onChange="imageUrl(this,'favIcon')">
                                <img src="{{ asset($settings->fav_icon) }}" width="50" height="auto" alt="" class="rounded float-end" id="favIcon">
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Logo</label>
                                <input name="logo" type="file" onChange="imageUrl(this,'logo')">
                                <img src="{{ asset($settings->logo) }}" width="100" height="auto" alt="" class="rounded float-end" id="logo">
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Front Image 1</label>
                                <input name="image_1" type="file" onChange="imageUrl(this,'image1')">
                                <img src="{{ asset($settings->image_1) }}" width="100" height="auto" alt="" class="rounded float-end" id="image1">
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Front Image 2</label>
                                <input name="image_2" type="file" onChange="imageUrl(this,'image2')">
                                <img src="{{ asset($settings->image_2) }}" width="100" height="auto" alt="" class="rounded float-end" id="image2">
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Front Image 3</label>
                                <input name="image_3" type="file" onChange="imageUrl(this,'image3')">
                                <img src="{{ asset($settings->image_3) }}" width="100" height="auto" alt="" class="rounded float-end" id="image3">
                            </div>
                            <div class="mb-3">
                                <label class="form-label w-100">Front Image 4</label>
                                <input name="image_4" type="file" onChange="imageUrl(this,'image4')">
                                <img src="{{ asset($settings->image_4) }}" width="100" height="auto" alt="" class="rounded float-end" id="image4">
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-12 col-xl-5">
                <div class="card">
                    
                    <div class="card-body">
                        <h4 class="card-title">Settings Information</h4>
                        <hr>
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Setting Data</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <tr>
                                    <td>Logo Text</td>
                                    <td>
                                        {{ $settings->logo_text??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Coyright Text</td>
                                    <td>
                                        {{ $settings->copyright_text??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Message Email</td>
                                    <td>
                                        {{ $settings->message_email??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Contact Email</td>
                                    <td>
                                        {{ $settings->contact_email??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Meta Keyworde</td>
                                    <td>
                                        {{ $settings->meta_keyword??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Review Box Title</td>
                                    <td>
                                        {{ $settings->review_box_title??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Body Title</td>
                                    <td>
                                        {{ $settings->body_title??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Body Description</td>
                                    <td>
                                        {{ $settings->body_description??''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>Fav Icon</td>
                                    <td>
                                        <img src="{{ asset($settings->fav_icon) }}" width="auto" height="50" class="rounded mx-auto d-block" alt="imange not found">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Logo</td>
                                    <td>
                                        <img src="{{ asset($settings->logo) }}" width="auto" height="50" class="rounded mx-auto d-block " alt="imange not found">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Front Image 1</td>
                                    <td>
                                        <img src="{{ asset($settings->image_1) }}" width="auto" height="50" class="rounded mx-auto d-block " alt="imange not found">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Front Image 2</td>
                                    <td>
                                        <img src="{{ asset($settings->image_2) }}" width="auto" height="50" class="rounded mx-auto d-block " alt="imange not found">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Front Image 3</td>
                                    <td>
                                        <img src="{{ asset($settings->image_3) }}" width="auto" height="50" class="rounded mx-auto d-block " alt="imange not found">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Front Image 4</td>
                                    <td>
                                        <img src="{{ asset($settings->image_4) }}" width="auto" height="50" class="rounded mx-auto d-block" alt="imange not found">
                                    </td>
                                </tr>
    
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>

    </div>
</main>
<script>
    function imageUrl(input,id){
        if(input.files && input.files[0]){
            var reader = new FileReader();
            reader.onload = function(e){
                $('#'+id).attr('src',e.target.result).width(100).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection