@extends('backend.layout')
@section('content')
<main class="content">
    <div class="container-fluid p-0">

        <div class="row mb-2 mb-xl-3">
            <div class="col-auto d-none d-sm-block">
                <h3><strong>All</strong> Review</h3>
            </div>
            
            <div class="col-auto ms-auto text-end mt-n1">
                <a href="{{ route('create.review') }}" class="btn btn-primary">Create New Review</a>
            </div> 
           
            
        </div>
        <div class="row">
            <div class="col-12">
                
                <div class="card">                    
                    <div class="card-body">
                        <table id="datatables-reponsive" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Review Text</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($reviews as $key => $item)
                                <tr>
                                    <td>{{ $key+1}}</td>
                                    <td><img class="rounded-circle" src="{{ (!empty($item->photo)) ? url($item->photo) : url('upload/no_image.jpg') }}" alt="" style="width: 70px; height:40px;"></td>
                                    <td>{{ $item->reviewer_name??''}}</td>
                                    <td>{{ $item->review_text?substr($item->review_text,0,40).'...':''}}</td>
                                    @if ($item->status == 'active')
                                        <td><a href="#" class="badge rounded-pill bg-success" onclick="changeReviewStatus({{ $item->id }})">Active</a></td>
                                        @else
                                        <td><a href="#" class="badge rounded-pill bg-danger" onclick="changeReviewStatus({{ $item->id }})">In Active</a></td>
                                    @endif
                                    <td>
                                        <a href="{{ route('edit.review',$item->id) }}" class="btn btn-pill btn-info" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit"> <i data-feather="edit"></i></a>
                                        <a href="{{ route('delete.review',$item->id) }}" class="btn btn-pill btn-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete"> <i data-feather="trash-2"></i></a>
                                    </td>
                                </tr>
                                @endforeach
                                
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</main>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Datatables Responsive
        $("#datatables-reponsive").DataTable({
            responsive: true,
            "drawCallback": function( settings ) {
                feather.replace();
            }
        });
    });

    function changeReviewStatus(id) {
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/change_review_status',
            data: {'id': id},
            success: function(data){
                
                
                // Start Message 
            const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    icon: 'success', 
                    showConfirmButton: false,
                    timer: 5000 
            })
            if ($.isEmptyObject(data.error)) {
                    
                    Toast.fire({
                    type: 'success',
                    title: data.success, 
                    })
            }else{
                
            Toast.fire({
                    type: 'error',
                    title: data.error, 
                    })
                }
                location.reload()
                // End Message   
            }
        });
    }
</script>
@endsection