@extends('backend.layout')
@section('content')
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
        background-color: #f6f6f6;
    }
    .container {
        width: 100%;
        max-width: 600px;
        margin: 0 auto;
        background-color: #ffffff;
        border-radius: 5px;
        overflow: hidden;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .header {
        background-color: #030734;
        color: white;
        padding: 20px;
        text-align: center;
    }
    .content {
        padding: 20px;
        line-height: 1.6;
    }
    .footer {
        background-color: #f1f1f1;
        text-align: center;
        padding: 10px;
        font-size: 12px;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    td {
        padding: 10px;
        border: 1px solid #dddddd;
    }
    a {
        color: #030734;
        text-decoration: none;
    }
</style>
<main class="content">
    <div class="container-fluid p-0">

        {{-- <div class="row mb-2 mb-xl-3">
            <div class="col-auto d-none d-sm-block">
                <h3><strong>Last 7 Days</strong> Email Report</h3>
            </div> 
        </div> --}}
        <div class="row">
            <div class="col-12">
                
                <div class="card">
                    <div class="card-header">
                        <h3><strong>View</strong> Email</h3>
                    </div>                    
                    <div class="card-body">
                        <table>
                            <tr>
                                <td style="width: 50% !important;"><strong>Title</strong></td>
                                <td style="width: 50% !important;"><strong>Information</strong></td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_1']??''}}</td>
                                <td>{{ $mailData['data']->input_field_1??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_2']??''}}</td>
                                <td>{{ $mailData['data']->input_field_2??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_3']??''}}</td>
                                <td>{{ $mailData['data']->input_field_3??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_4']??''}}</td>
                                <td>{{ $mailData['data']->input_field_4??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_5']??''}}</td>
                                <td>{{ $mailData['data']->input_field_5??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_6']??''}}</td>
                                <td>{{ $mailData['data']->input_field_6??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_7']??''}}</td>
                                <td>{{ $mailData['data']->input_field_7??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_8']??''}}</td>
                                <td>{{ $mailData['data']->input_field_8??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_9']??''}}</td>
                                <td>{{ $mailData['data']->input_field_9??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_10']??''}}</td>
                                <td>{{ $mailData['data']->input_field_10??''}}</td>
                            </tr>
                            <tr>
                                <td>{{ $mailData['input_field']['input_field_11']??''}}</td>
                                <td>{{ $mailData['data']->input_field_11??''}}</td>
                            </tr>
            
                            
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</main>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Datatables Responsive
        $("#datatables-reponsive").DataTable({
            responsive: true
        });
    });

    function changeReviewStatus(id) {
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/change_review_status',
            data: {'id': id},
            success: function(data){
                
                
                // Start Message 
            const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    icon: 'success', 
                    showConfirmButton: false,
                    timer: 5000 
            })
            if ($.isEmptyObject(data.error)) {
                    
                    Toast.fire({
                    type: 'success',
                    title: data.success, 
                    })
            }else{
                
            Toast.fire({
                    type: 'error',
                    title: data.error, 
                    })
                }
                location.reload()
                // End Message   
            }
        });
    }
</script>
@endsection