<?php

namespace App\Http\Controllers\Backend;

use DB;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\Rules;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Intervention\Image\ImageManager;
use App\Http\Requests\UpdateUserRequest;
use Intervention\Image\Drivers\Gd\Driver;


class UserController extends Controller
{
    public function index(){
        $users = User::all()->sortByDesc('id')->values();
        // dd($users);
        return view('backend.user.all_user',compact('users'));
    } // end index

    public function create(){
        return view('backend.user.create_user');
    } // end create

    public function store(Request $request){
        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'name' => ['required','string','max:255'],
                'email' => ['required','string','lowercase','max:255','unique:'.User::class],
                'password' => ['required', 'confirmed', Rules\Password::defaults()],
                'photo' => ['image','mimes:jpeg,png,jpg']
            ]);

            if($request->file('photo')){
                $selected_image = $request->file('photo');
                $manager = new ImageManager(new Driver());
                $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                $img = $manager->read($selected_image);
                $img = $img->resize(300,300);
                $img->toJpeg(80)->save('upload/admin_images/'.$name_gen);
                $image_url = 'upload/admin_images/'.$name_gen;

                $user = User::insert([
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'photo' => $image_url,
                    'created_at' =>  Carbon::now()
    
                ]);
            }else{
                $user = User::insert([
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'created_at' =>  Carbon::now()
    
                ]);
            }
            
            $notification = array(
                'message' => 'User created successfully!',
                'alert-type' => 'success'
            );
            
            DB::commit();
            return redirect()->route('all.user')->with($notification);

        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
    } //end store

    public function edit($id){
        $userInfo = User::where('id',$id)->first();
        return view('backend.user.edit_user',compact('userInfo'));
    } // end edit

    public function update(Request $request){
        $user_id = $request->user_id;
        $user_photo = $request->user_photo;
        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'name' => ['required','string','max:255'],
                'email' => 'required|email|string|lowercase|max:255|unique:users,email,' . $user_id,
                'password' => ['required', 'confirmed', Rules\Password::defaults()],
                'photo' => ['image','mimes:jpeg,png,jpg']
            ]);

            if($request->file('photo')){
                $file = $request->file('photo');
                $selected_image = $request->file('photo');
                $manager = new ImageManager(new Driver());
                $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                $img = $manager->read($selected_image);
                $img = $img->resize(300,300);
                $img->toJpeg(80)->save('upload/admin_images/'.$name_gen);
                $image_url = 'upload/admin_images/'.$name_gen;

                if(file_exists($user_photo)){
                    unlink($user_photo);
                }

                $user = User::where('id',$user_id)
                ->update([
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'role' => $request->role,
                    'photo' => $image_url,
    
                ]);
            }else{
                $user = User::where('id',$user_id)
                ->update([
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'role' => $request->role,
    
                ]);
            }

            $notification = array(
                'message' => 'User Updated successfully!',
                'alert-type' => 'success'
            );
            
            DB::commit();
            return redirect()->route('all.user')->with($notification);

        } catch (\Exception $e) {
            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
    } //end update

    public function changeUserStatus(Request $request){
        $info = User::find($request->id);
        
        if($info->status == 'active'){
            $info->status = 'inactive';
        }else{
            $info->status = 'active';
        }
        // dd($info,$info->save());
        $info->save();
        return response()->json(['success'=>'Status Changed successfully']);
    }
}
