<?php

namespace App\Http\Controllers\Backend;

use DB;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Intervention\Image\ImageManager;
use App\Models\InputFieldPlaceHolder;
use Intervention\Image\Drivers\Gd\Driver;

class SettingController extends Controller
{
    public function index(){
        $settings = Setting::first();
        return view('backend.settings.settings',compact('settings'));
    } // settings

    public function store(Request $request){
        $setting_id = $request->setting_id;
        $current_data = Setting::where('id',$setting_id)->first();
        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'logo_text' => ['string','max:255'],
                'copyright_text' => ['required','string','max:255'],
                'message_email' => ['required','email','max:255'],
                'contact_email' => ['email','max:255'],
                'meta_keyword' => ['string','max:255'],
                'body_title' => ['string','max:255'],
                'review_box_title' => ['string','max:255'],
                'body_description' => ['string','max:255'],
                'fav_icon' => ['image','mimes:jpeg,png,jpg'],
                'logo' => ['image','mimes:jpeg,png,jpg'],
                'image_1' => ['image','mimes:jpeg,png,jpg'],
                'image_2' => ['image','mimes:jpeg,png,jpg'],
                'image_3' => ['image','mimes:jpeg,png,jpg'],
                'image_4' => ['image','mimes:jpeg,png,jpg']
            ]);

            if($request->file('fav_icon') || $request->file('logo') || $request->file('image_1') || $request->file('image_2') || $request->file('image_3') || $request->file('image_4')){
                
                $fav_icon_url = $current_data->fav_icon;
                if($request->file('fav_icon')){
                    $selected_image = $request->file('fav_icon');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(48,48);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $fav_icon_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->fav_icon)){
                        unlink($current_data->fav_icon);
                    }
                }
                $logo_url = $current_data->logo;
                if($request->file('logo')){
                    $selected_image = $request->file('logo');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(125,75);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $logo_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->logo)){
                        unlink($current_data->logo);
                    }
                }
                $image_1_url = $current_data->image_1;
                if($request->file('image_1')){
                    $selected_image = $request->file('image_1');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(382,254);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $image_1_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->image_1)){
                        unlink($current_data->image_1);
                    }
                }
                $image_2_url = $current_data->image_2;
                if($request->file('image_2')){
                    $selected_image = $request->file('image_2');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(382,254);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $image_2_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->image_2)){
                        unlink($current_data->image_2);
                    }
                }
                $image_3_url = $current_data->image_3;
                if($request->file('image_3')){
                    $selected_image = $request->file('image_3');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(382,254);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $image_3_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->image_3)){
                        unlink($current_data->image_3);
                    }
                }
                $image_4_url = $current_data->image_4;
                if($request->file('image_4')){
                    $selected_image = $request->file('image_4');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(382,254);
                    $img->toJpeg(80)->save('upload/settings_images/'.$name_gen);
                    $image_4_url = 'upload/settings_images/'.$name_gen;

                    if(file_exists($current_data->image_4)){
                        unlink($current_data->image_4);
                    }
                }
                
                Setting::updateOrCreate(
                    ['id' => $setting_id],
                    [
                        'logo_text' => $request->logo_text,
                        'copyright_text' => $request->copyright_text,
                        'message_email' => $request->message_email,
                        'contact_email' => $request->contact_email,
                        'meta_keyword' => $request->meta_keyword,
                        'body_title' => $request->body_title,
                        'review_box_title' => $request->review_box_title,
                        'body_description' => $request->body_description,
                        'fav_icon' => $fav_icon_url,
                        'logo' => $logo_url,
                        'image_1' =>  $image_1_url,
                        'image_2' =>  $image_2_url,
                        'image_3' =>  $image_3_url,
                        'image_4' =>  $image_4_url
                    ]
                );
            }else{
                Setting::updateOrCreate(
                    ['id' => $setting_id],
                    [
                        'logo_text' => $request->logo_text,
                        'copyright_text' => $request->copyright_text,
                        'message_email' => $request->message_email,
                        'contact_email' => $request->contact_email,
                        'meta_keyword' => $request->meta_keyword,
                        'body_title' => $request->body_title,
                        'review_box_title' => $request->review_box_title,
                        'body_description' => $request->body_description
                    ]
                );
            }
            $notification = array(
                'message' => 'Data Saved Successfully!!',
                'alert-type' => 'success'
            );

            DB::commit();

            return redirect()->back()->with($notification);
        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
        
    } // end of store

    public function editInputField(){
        $input_field_data = InputFieldPlaceHolder::first();
        return view('backend.settings.edit_input_field',compact('input_field_data'));
    } // editInputField

    public function updateInputField(Request $request){
        $input_field_id = $request->input_field_id;
        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'input_field_1' => ['string','max:255'],
                'input_field_2' => ['string','max:255'],
                'input_field_3' => ['string','max:255'],
                'input_field_4' => ['string','max:255'],
                'input_field_5' => ['string','max:255'],
                'input_field_6' => ['string','max:255'],
                'input_field_7' => ['string','max:255'],
                'input_field_8' => ['string','max:255'],
                'input_field_9' => ['string','max:255'],
                'input_field_10' => ['string','max:255'],
                'input_field_11' => ['string','max:255']
            ]);

            InputFieldPlaceHolder::updateOrCreate(
                ['id' => $input_field_id],
                [
                    'input_field_1' => $request->input_field_1,
                    'input_field_2' => $request->input_field_2,
                    'input_field_3' => $request->input_field_3,
                    'input_field_4' => $request->input_field_4,
                    'input_field_5' => $request->input_field_5,
                    'input_field_6' => $request->input_field_6,
                    'input_field_7' => $request->input_field_7,
                    'input_field_8' => $request->input_field_8,
                    'input_field_9' => $request->input_field_9,
                    'input_field_10' => $request->input_field_10,
                    'input_field_11' => $request->input_field_11
                ]
            );

            $notification = array(
                'message' => 'Data Saved Successfully!!',
                'alert-type' => 'success'
            );

            DB::commit();

            return redirect()->back()->with($notification);
        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
        
    } // end of updateInputField
}
