<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Models\CustomerMessage;
use App\Http\Controllers\Controller;
use App\Models\InputFieldPlaceHolder;

class ReportController extends Controller
{
    public function emailReport(){
        $startDate = date('Y-m-d',strtotime("-7 day"));
        $endDate = date('Y-m-d');
        $mailData = CustomerMessage::whereBetween('mail_sent_date', [$startDate, $endDate])->get();
        return view('backend.report.email_report',compact('mailData'));
    } // end of emailReport

    public function viewMail($id){
        $mailData['input_field'] = InputFieldPlaceHolder::first();
        $form_data = CustomerMessage::where('id',$id)->first()->form_data;
        $mailData['data'] = json_decode($form_data);
        return view('backend.report.view_mail',compact('mailData'));
    } // end of viewMail
}
