<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Models\CustomerMessage;
use App\Http\Controllers\Controller;
use App\Models\InputFieldPlaceHolder;

class IndexController extends Controller
{

    public function index(){
        $startDate = date('Y-m-d',strtotime("-7 day"));
        $endDate = date('Y-m-d');
        $allData = CustomerMessage::orderBy('id','desc')->get();
        $lastSevenDaysMail = $allData->whereBetween('mail_sent_date', [$startDate, $endDate])->values()->all();
        $allDataCount = count($allData);
        $lastSevenDaysEmailCount = count($lastSevenDaysMail);
        $data['lastSevenDaysMail'] = $lastSevenDaysMail;
        $data['allDataCount'] = $allDataCount;
        $data['lastSevenDaysEmailCount'] = $lastSevenDaysEmailCount;
        return view('backend.dashboard.dashboard',compact('data'));
    } // end of emailReport

    public function viewMail($id){
        $mailData['input_field'] = InputFieldPlaceHolder::first();
        $form_data = CustomerMessage::where('id',$id)->first()->form_data;
        $mailData['data'] = json_decode($form_data);
        return view('backend.dashboard.view_mail',compact('mailData'));
    } // end of viewMail
}
