<?php

namespace App\Http\Controllers\Backend;

use DB;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\CustomerReview;
use App\Http\Controllers\Controller;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

class CustomerReviewController extends Controller
{
    public function index(){
        $reviews = CustomerReview::all()->sortByDesc('id')->values();
        return view('backend.review.all_review',compact('reviews'));
    } // end index

    public function create(){
        return view('backend.review.create_review');
    } //end create

    public function store(Request $request){
        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'reviewer_name' => ['required','string','max:255'],
                'review_text' => ['required','string'],
                'photo' => ['image','mimes:jpeg,png,jpg']
            ]);

                if($request->file('photo')){
                    $selected_image = $request->file('photo');
                    $manager = new ImageManager(new Driver());
                    $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                    $img = $manager->read($selected_image);
                    $img = $img->resize(300,300);
                    $img->toJpeg(80)->save('upload/review_images/'.$name_gen);
                    $image_url = 'upload/review_images/'.$name_gen;

                    $review = CustomerReview::insert([
                        'reviewer_name' => $request->reviewer_name,
                        'review_text' => $request->review_text,
                        'photo' => $image_url,
                        'created_at' => Carbon::now()
                    ]);
                }else{
                    $review = CustomerReview::insert([
                        'reviewer_name' => $request->reviewer_name,
                        'review_text' => $request->review_text,
                        'created_at' => Carbon::now()
                    ]);
                }

            

            $notification = array(
                'message' => 'Review Created Successfully!!',
                'alert-type' => 'success'
            );

            DB::commit();
            return redirect()->route('all.review')->with($notification);
        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
    } // end store

    public function edit($id){
        $reviewInfo = CustomerReview::where('id',$id)->first();
        return view('backend.review.edit_review',compact('reviewInfo'));
    } // end edit

    public function update(Request $request){
        $review_id = $request->review_id;
        $reviewer_photo = $request->reviewer_photo;

        DB::beginTransaction();
        try {
            $validated = $request->validate([
                'reviewer_name' => ['required','string','max:255'],
                'review_text' => ['required','string'],
                'photo' => ['image','mimes:jpeg,png,jpg']
            ]);

            if($request->file('photo')){
                $file = $request->file('photo');
                
                $selected_image = $request->file('photo');
                $manager = new ImageManager(new Driver());
                $name_gen = hexdec(uniqid()).'.'.$selected_image->getClientOriginalExtension();
                $img = $manager->read($selected_image);
                $img = $img->resize(300,300);
                $img->toJpeg(80)->save('upload/review_images/'.$name_gen);
                $image_url = 'upload/review_images/'.$name_gen;

                if(file_exists($reviewer_photo)){
                    unlink($reviewer_photo);
                }

                $review = CustomerReview::where('id',$review_id)
                ->update([
                    'reviewer_name' => $request->reviewer_name,
                    'review_text' => $request->review_text,
                    'photo' => $image_url,
                ]);
            }else{
                $review = CustomerReview::where('id',$review_id)
                ->update([
                    'reviewer_name' => $request->reviewer_name,
                    'review_text' => $request->review_text,
                ]);
            }

            $notification = array(
                'message' => 'Review Updated Successfully!!',
                'alert-type' => 'success'
            );

            DB::commit();
            return redirect()->route('all.review')->with($notification);
        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
    } // end update

    public function delete($id){
        $reviewer_photo = CustomerReview::where('id',$id)->first()->photo;
        DB::beginTransaction();
        try {
            $delete_review = CustomerReview::where('id',$id)->delete();
            if($delete_review){
                unlink($reviewer_photo);
            }
            $notification = array(
                'message' => 'Review deleted succyssfully!!',
                'alert-type' => 'error'
            );

            DB::commit();
            return redirect()->route('all.review')->with($notification);
        } catch (\Exception $e) {

            DB::rollback();
                $message = $e->getMessage();
                $notification = array(
                    'message' => $message,
                    'alert-type' => 'error'
                );
            return redirect()->back()->with($notification);
        }
    } // end delete

    public function changeReviewStatus(Request $request){
        $info = CustomerReview::find($request->id);
        
        if($info->status == 'active'){
            $info->status = 'inactive';
        }else{
            $info->status = 'active';
        }
        // dd($info,$info->save());
        $info->save();
        return response()->json(['success'=>'Status Changed successfully']);
    }
}
